/*
 * Decompiled with CFR 0.152.
 */
package emulator.unittest.assembler;

import emulator.assembler.SymbolTableEntry;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class SymbolTableEntryTest {
    @Before
    public void setUp() throws Exception {
    }

    @Test
    public void testInvalidSymbolsFromString() {
        Assert.assertNull((Object)SymbolTableEntry.createFromString(""));
        Assert.assertNull((Object)SymbolTableEntry.createFromString(";0 null A Zero DATA"));
        Assert.assertNull((Object)SymbolTableEntry.createFromString("6767"));
        Assert.assertNull((Object)SymbolTableEntry.createFromString(";c369           'error'                                 DATA"));
    }

    @Test
    public void testShortSymbolsFromString() {
        this.checkSymbolFromString("A000 modulram", 40960, "modulram", null, 1);
    }

    @Test
    public void testValidSymbolsFromString() {
        this.checkSymbolFromString("c000    -       Basic Restart Vectors                   WORD", 49152, null, "Basic Restart Vectors", 3);
    }

    @Test
    public void testCodeDefaultSymbolsFromString() {
        this.checkSymbolFromString("c000    -       Basic Restart Vectors", 49152, null, "Basic Restart Vectors", 1);
    }

    @Test
    public void testCC65LabelFromString() {
        this.checkSymbolFromString("al 00FFA5 .ACPTR", 65445, "ACPTR", null, 0);
    }

    private void checkSymbolFromString(String string, int address, String label, String remark, int symbol_type) {
        SymbolTableEntry entry = SymbolTableEntry.createFromString(string);
        Assert.assertNotNull((Object)entry);
        Assert.assertEquals((long)address, (long)entry.getAddress());
        Assert.assertEquals((Object)label, (Object)entry.getLabel());
        Assert.assertEquals((Object)remark, (Object)entry.getRemark());
        Assert.assertEquals((long)symbol_type, (long)entry.getType());
    }
}

